<?php

use app\models\active\Battles_user;
use yii\helpers\Html;
use app\models\User;

$this->title = 'Сражение';
?>
    <style>
        #progressBar {
            height: 10px;
            background-color: #f00;
        }
    </style>

    <div class="feedback">
        <?php echo $this->title; ?>
    </div>
    <div style="background: url('/images/battle-bg/<?php echo $battle->image; ?>.png');max-width: 450px;max-height: 150px;z-index: 10;padding-bottom: 2px;">
        <div class="text-center">
            <?php if (!empty($in_battle->death)): ?>
                Вы погибли в сражении
            <?php else: ?>
                <?php if (!empty($npc_count) || !empty($boss_count)): ?>
                    <table width="100%;">
                        <tr>
                            <td width="25%">
                                <img src="/images/avatar/user/<?php echo Yii::$app->user->identity->sex; ?>/<?php echo Yii::$app->user->identity->avatar; ?>.png"
                                     class="u-m" width="64px;" height="64px;"><br>
                                <progress value="<?php echo $in_battle->health ?>"
                                          max="<?php echo $in_battle->full_health ?>" style="width: 120px;">
                                </progress>
                                <img src="/images/icons/health.png" width="16px;" title="Здоровье"
                                     style="vertical-align: middle;"><?php echo $in_battle->health ?>
                            </td>
                            <td width="50%">
                                <?php if (!empty($enemy)): ?>
                                    <a id="a_enemy" href="/battle?attack=enemy"
                                       class="btn" style="width: 90%;">Добивать <?php echo Html::encode($enemy->name); ?></a><br>
                                <?php endif; ?>
                                <a id="a_random" href="/battle?attack=random" class="btn" style="width: 90%;">Атаковать</a><br>
                                <div id="cooldown"
                                     style="display: block;width: 96%;height: 10px;border: 1px solid #252525;margin: 4px;">
                                    <div id="progressBar"></div>
                                </div>
                            </td>
                            <td width="25%">
                                	<img src="/web/images/bot/<?php echo (!empty($enemy) ? $enemy->image : '0'); ?>.png" class="u-m" width="64px" height="64px"><br>
                                <?php if (!empty($enemy)): ?>
                                    <progress value="<?php echo $enemy->health ?>" max="<?php echo $enemy->full_health ?>" style="width: 120px;">
                                    </progress>
                                    <img src="/images/icons/health.png" width="16px;" title="Здоровье"
                                         style="vertical-align: middle;"><?php echo $enemy->health ?>
                                <?php else: ?>

                                <?php endif; ?>
                            </td>
                        </tr>
                    </table>


                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>

    <div class="feedback">
        Журнал сражения
    </div>

    <div class="feedback" style="text-align: left;">
        <?php if (empty($battle_log)): ?>
            Пусто
        <?php else: ?>
            <?php foreach ($battle_log as $log): ?>
                <span style="display: block; font-size: 10px;">
            <?php echo $log['text']; ?> <span
                            class="tgray"><?php echo Yii::$app->formatter->format($log['time'], 'relativeTime'); ?></span>
        </span>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

<?php
$script = <<< JS
    function cooldown(){
        var i = 0;
        var width = document.getElementById('progressBar').parentNode.clientWidth;
        var id = setInterval(grow, 6)
        
        function grow(){
        if(i < width){
            i += 1;
        if(!document.getElementById('progressBar').setAttribute("style","width: "+i+"px;"))
            document.getElementById('progressBar').style.width = i;
        }else{
        }
        }
    }
    
    setTimeout(cooldown, 100);
JS;

$this->registerJs($script, $this::POS_END);